(
	-- Arch&Design Material

    struct AMGData
	(
		fn GetUUID mtl context = 
		(
			"019b2fab-058c-4877-8d02-e6c4b20ebe8f"
		)
		,
		fn GetMaps mtl context = 
		(
			local res = #()	

			if mtl.diffuse_weight > 0 do (
				if mtl.diff_color_map != undefined and mtl.diff_color_map_on do 
					append res #("diffuse", mtl.diff_color_map)
				if mtl.diff_rough_map != undefined and mtl.diff_rough_map_on do 
					append res #("diffuse_roughness", mtl.diff_rough_map, "resultFloat")
			)

			if mtl.refl_weight > 0 do (
				if mtl.refl_color_map != undefined and mtl.refl_color_map_on do 
					append res #("refl_color", mtl.refl_color_map)
				if mtl.refl_gloss_map != undefined and mtl.refl_gloss_map_on do 
					append res #("refl_gloss", mtl.refl_gloss_map, "resultFloat")

				if mtl.anisotropy_map != undefined and mtl.anisotropy_map_on do 
					append res #("anisotropy",  mtl.anisotropy_map, "resultFloat")
				if mtl.anisoangle_map != undefined and mtl.anisoangle_map_on do 
					append res #("angle",       mtl.anisoangle_map, "resultFloat")

				if mtl.aniso_mode == 1 do 
				(
					append res #("utangent", undefined, "u_tangent_" + (mtl.aniso_channel as String))
					append res #("vtangent", undefined, "v_tangent_" + (mtl.aniso_channel as String))
				)
			)

			if mtl.refr_weight > 0 do (
				if mtl.refr_color_map != undefined and mtl.refr_color_map_on do 
					append res #("refr_color", mtl.refr_color_map)
				if mtl.refl_gloss_map != undefined and mtl.refl_gloss_map_on do 
					append res #("refr_gloss", mtl.refr_gloss_map, "resultFloat")

				if mtl.refr_trans_on do (
					if mtl.refr_transc_map != undefined and mtl.refr_transc_map_on do 
						append res #("refr_transc", mtl.refr_transc_map)
					if mtl.refr_transw_map != undefined and mtl.refr_transw_map_on do 
						append res #("refr_transw", mtl.refr_transw_map, "resultFloat")
				)
			)

			if mtl.refr_ior_map != undefined and mtl.refr_ior_map_on do 
				append res #("refr_ior", mtl.refr_ior_map, "resultFloat")

			if mtl.bump_map != undefined and mtl.bump_map_on do 
				append res #("normal_perturb", mtl.bump_map, "normalPerturb", 1)

			if mtl.self_illum_on and mtl.self_illum_map != undefined and mtl.self_illum_map_on do 
				append res #("emission_filter", mtl.self_illum_map)
			if mtl.cutout_map != undefined and mtl.cutout_map_on do 
				append res #("cutout_opacity", mtl.cutout_map, "resultFloat")

			if mtl.add_color_map != undefined  and mtl.add_color_map_on do 
				append res #("additional_color", mtl.add_color_map)

			res
		),

		fn GetParams mtl context =
		(
			local res = #()	

			append res #("diffuse",           mtl.diff_color)
			append res #("diffuse_weight",    mtl.diff_weight)
			append res #("diffuse_roughness", mtl.diff_rough)

			append res #("reflectivity",      mtl.refl_weight)
			if mtl.refl_weight > 0 do (
				append res #("refl_use_ior",      mtl.refl_func_fresnel)
				append res #("refl_exponent",     mtl.refl_func_curve)
				append res #("refl_curve_low",    mtl.refl_func_low)
				append res #("refl_curve_high",   mtl.refl_func_high)

				append res #("refl_color",        mtl.refl_color)
				append res #("refl_gloss",        mtl.refl_gloss)
				append res #("refl_is_metal",     mtl.refl_metal)
				append res #("anisotropy",        mtl.anisotropy)
				append res #("angle",             mtl.anisoangle)
			)

			append res #("thin_walled",       mtl.opts_1sided)

			append res #("transparency",      mtl.refr_weight) 
			if mtl.refr_weight > 0.0 do (
				append res #("refr_color",        mtl.refr_color)
				append res #("refr_gloss",        mtl.refr_gloss)

				if mtl.refr_trans_on do (
					append res #("refr_transc",  mtl.refr_transc)
					append res #("refr_transw",  mtl.refr_transw)
				)
			)

			append res #("refr_ior",          mtl.refr_ior)

			local emit = false

			if mtl.self_illum_on then (
				append res #("emission_filter",  mtl.self_illum_color_filter)
				append res #("emission",         mtl.EffectiveSelfIllum)
				emit = true
			)
			else
			(
				append res #("emission",  (color 0 0 0))
			)

			if mtl.add_color_map != undefined  and mtl.add_color_map_on do (
				emit = true
			)

			append res #("att:emissive", emit) 

			append res #("no_diffuse_bump",  mtl.no_diffuse_bump)

			append res #("bump_amount",      mtl.bump_map_amt)

			append res #("cutout_opacity", 1.0) -- default to Opaque

			res
		)
	)

	AMGData()	
)
